﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace DrawingInWPF
{
    public class ZoomPan
    {
        #region Members

        private double m_ZoomFactor = 1;
        private Point m_Center = new Point();
        private TranslateTransform m_TranslateTransform = new TranslateTransform();
        private ScaleTransform m_ScaleTransform = new ScaleTransform();
        private TransformGroup m_TransformGroup = new TransformGroup();

        #endregion

        #region Properties

        public double Width { get; set; }
        public double Height { get; set; }
        
        public TransformGroup Transform
        {
            get { return m_TransformGroup; }
            set { m_TransformGroup = value; }
        }


        #endregion

        #region Methods

        public ZoomPan()
        {
            m_TransformGroup.Children.Add(m_ScaleTransform);
            m_TransformGroup.Children.Add(m_TranslateTransform);
        }

        private void UpdateTransform()
        {
            m_TranslateTransform.X = Width / 2 - m_Center.X;
            m_TranslateTransform.Y = Height / 2 - m_Center.Y;

            m_ScaleTransform.CenterX = m_Center.X;
            m_ScaleTransform.CenterY = m_Center.Y;

            m_ScaleTransform.ScaleX = m_ZoomFactor;
            m_ScaleTransform.ScaleY = -m_ZoomFactor;
        }

        public void ZoomIn()
        {
            m_ZoomFactor *= 1.2;
            UpdateTransform();
        }

        public void ZoomOut()
        {
            m_ZoomFactor /= 1.2;
            UpdateTransform();
        }

        public void Pan(double offsetX, double offsetY)
        {
            m_Center.X -= (offsetX / m_ZoomFactor);
            m_Center.Y += (offsetY / m_ZoomFactor);
            UpdateTransform();
        }

        public void ZoomAll(double centerX, double centerY, double zoomfactor)
        {
            m_Center.X = centerX;
            m_Center.Y = centerY;
            m_ZoomFactor = zoomfactor;
            UpdateTransform();
        }

        public void ZoomToWindow(Point startPoint, Point endPoint)
        {
            Vector newCenter = new Vector((startPoint.X + endPoint.X) / 2, (startPoint.Y + endPoint.Y) / 2);
            Vector oldCenter = new Vector(Width/2, Height/2);

            Vector offsetVector = oldCenter - newCenter;

            m_Center.X -= (offsetVector.X / m_ZoomFactor);
            m_Center.Y += (offsetVector.Y / m_ZoomFactor);

            double xDelta = Math.Abs(startPoint.X - endPoint.X) / m_ZoomFactor;
            double yDelta = Math.Abs(startPoint.Y - endPoint.Y) / m_ZoomFactor;

            double xRatio = Width / xDelta;
            double yRatio = Height / yDelta;

            double ratio = (xRatio < yRatio) ? xRatio : yRatio;

            m_ZoomFactor = ratio;

            UpdateTransform();
        }

        #endregion
    }
}
